﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Sales
{
    public partial class OrderDetails : System.Web.UI.Page
    {
        private Orders currentOrder;

        protected void Page_Load(object sender, EventArgs e)
        {
           WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                if (Request.QueryString["UniqueID"] != null)
                {
                    hdOrdersID.Value = Request.QueryString["UniqueID"].ToString();
                    BindOrderDetails();
                }
                else
                {
                    Response.Redirect("~/Admin/Sales/Sales.aspx", false);
                }
            }
        }

        private void BindOrderDetails()
        {
            currentOrder = OrdersBL.GetItem(Guid.Parse(hdOrdersID.Value.Trim()), Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);

            if (currentOrder != null)
            {
                grdOrderDetails.DataSource = currentOrder.OrdersDetailsList;
                grdOrderDetails.DataBind();

                //btnDownLoadInvoice.Visible = lnkInvoice.Visible = !string.IsNullOrEmpty(currentOrder.InvoiceNo);
                //btnGenerateInvoice.Visible = string.IsNullOrEmpty(currentOrder.InvoiceNo);
                //btnGenerateDO.Visible = ((from od in currentOrder.OrdersDetailsList
                //                          where od.DONumber.Trim().Length == 0
                //                          select od).Count() > 0 && currentOrder.InvoiceNo.Trim().Length > 0);

                //lnkInvoice.NavigateUrl = "~/Admin/Sales/ViewInvoice.aspx?UniqueID=" + currentOrder.UniqueID.ToString();
            }
        }

        protected void btnGenerateInvoice_Click(object sender, EventArgs e)
        {
            currentOrder = OrdersBL.GetItem(Guid.Parse(hdOrdersID.Value.Trim()), Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
            if (OrdersBL.GenerateInvoice(currentOrder.UniqueID))
            {
                AuditTrailBL.Save(currentOrder.UniqueID, WebSession.GetUserIP(), "Generated the Invoice.", Guid.Empty, currentOrder.AdminUserAccountID);
                BindOrderDetails();
                WebUtilities.ShowMessage(this, "Invoice has beed generated successfully");
            }
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindOrderDetails();
            Master.ExportToExcel<Entities.Orders>(grdOrderDetails, "OrderDetails");
        }

        protected void btnDownLoadInvoice_Click(object sender, EventArgs e)
        {
            GeneratePDF.GenerateInvoicePDF(Guid.Parse(hdOrdersID.Value.Trim()), true, Response);
        }

        protected void btnGenerateDO_Click(object sender, EventArgs e)
        {
            string remarks = string.Empty;
            currentOrder = OrdersBL.GetItem(Guid.Parse(hdOrdersID.Value.Trim()), Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);

            string newDoNumber = OrdersDetailsBL.GetNewDONumber(currentOrder.UniqueID, Guid.Empty, currentOrder.InvoiceNo);

            foreach (GridViewRow gRow in grdOrderDetails.Rows)
            {
                CheckBox chkSelect = gRow.FindControl("chkSelect") as CheckBox;
                HiddenField hdOrdersDetailsID = gRow.FindControl("hdOrdersDetailsID") as HiddenField;

                if (chkSelect != null && chkSelect.Checked)
                {
                    OrdersDetails od = OrdersDetailsBL.GetItem(Guid.Parse(hdOrdersDetailsID.Value.Trim()), Guid.Empty, string.Empty);
                    od.Mode = GlobalConfigurations.Mode.Update;
                    od.DONumber = newDoNumber;
                    od.DODate = DateTime.Now;
                    od.UserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);
                    OrdersDetailsBL.Save(od);
                    remarks += od.ProductName + Environment.NewLine;
                }
            }

            if (remarks.Trim().Length != 0)
                AuditTrailBL.Save(currentOrder.UniqueID, WebSession.GetUserIP(), string.Format("{0}{1}{2}", "Generated DO for", Environment.NewLine, remarks), Guid.Empty, currentOrder.AdminUserAccountID);

            BindOrderDetails();
            WebUtilities.ShowMessage(this, "DO has beed generated successfully");
        }

        protected void lnkDownloadDO_Click(object sender, EventArgs e)
        {
            LinkButton lnkDownloadDO = sender as LinkButton;
            OrdersDetails od = OrdersDetailsBL.GetItem(Guid.Parse(lnkDownloadDO.CommandArgument.Trim()), Guid.Empty, string.Empty);
            GeneratePDF.GenerateDOPDF(od.OrdersID, od.DONumber, true, Response);
        }
    }
}